unit IWTemplateProcessorHTML32;

interface

Uses
  {$IFDEF VSNET}
  System.ComponentModel,
  System.Drawing,
  IWTemplateFiles32Converter,
  {$ENDIF}
  Classes,
  IWContainer32Layout, IWRenderContext, IWTypes, IWStreams, IWBaseRenderContext;

Type
  {$IFDEF VSNET}
  [TypeConverter(typeof(TIWTemplateFiles32Converter))]
  {$ENDIF}
  TIWTemplateFiles32 = class(TPersistent)
  protected
    FDefault: string;
    //
    procedure AssignTo(ADest: TPersistent); override;
  public
    constructor Create(ADefault: String); overload;
  published
    property Default: string read FDefault write FDefault;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWTemplateProcessorHTML32.bmp}
  TIWTemplateProcessorHTML32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWTemplateProcessorHTML32), 'TIWTemplateProcessorHTML32.bmp')]
  {$ENDIF}
  TIWTemplateProcessorHTML32 = class(TIWContainer32Layout)
  protected
    FMasterFormTag: Boolean;
    FOnAfterProcess: TIWTemplateProcessEvent;
    FOnBeforeProcess: TIWTemplateProcessEvent;
    FOnUnknownTag: TIWUnknownTagEvent;
    FTagType: TIWTemplateLayoutHTMLTagType;
    FTemplates: TIWTemplateFiles32;
    //
    function DoUnknownTag(const AName: string): string;
    procedure SetTemplates(const AValue: TIWTemplateFiles32);

    // function GetComponents: TList; override;

    // procedure Loaded; override;

    procedure InitControl; override;
  {$IFDEF CLR}
  strict protected
  {$ELSE}
  protected
  {$ENDIF}
    procedure Dispose(ADispose: Boolean); override;
  public
    function Able: Boolean; override;
    procedure Process(AStream: TIWRenderStream; AContainerContext: TIWContainerContext; APageContext: TIWBasePageContext); override;
    procedure ProcessStream(AStream: TIWRenderStream; ATemplateStream: TStream; AContainerContext: TIWContainerContext; APageContext: TIWBasePageContext);
    function TemplatePathname: string;
  published
    property MasterFormTag: Boolean read FMasterFormTag write FMasterFormTag;
    property TagType: TIWTemplateLayoutHTMLTagType read FTagType write FTagType;
    property Templates: TIWTemplateFiles32 read FTemplates write SetTemplates;
    property OnUnknownTag: TIWUnknownTagEvent read FOnUnknownTag write FOnUnknownTag;
    property OnBeforeProcess: TIWTemplateProcessEvent read FOnBeforeProcess write FOnBeforeProcess;
    property OnAfterProcess: TIWTemplateProcessEvent read FOnAfterProcess write FOnAfterProcess;
  end;

implementation

Uses
  CopyPrsr, SysUtils,
  {$IFDEF VCL6PRABOVE}
  Variants,
  {$ENDIF}
  {$IFDEF VSNET}
  System.IO,
  {$ENDIF}  
  IWUtils, IWGlobal, IWHTMLTag, IWHTML32Interfaces, IWApplication, IWBaseInterfaces,
  IWBaseHTMLInterfaces, SWStrings, SWSystem, IWBaseContainerLayout,
  IWMarkupLanguageTag, InGlobal;

{ TIWTemplateProcessorHTML32 }

function TIWTemplateProcessorHTML32.Able: Boolean;
{$IFDEF VSNET}
var
  LInfo : FileInfo;
{$ENDIF}
begin
  Result := False;
  if Enabled then begin
    Result := FileExists(TemplatePathname) or Assigned(FOnBeforeProcess);
{$IFDEF VSNET}
  if FileExists(TemplatePathname) then begin
    LInfo := FileInfo.Create(TemplatePathname);
    if LInfo.Length = 0 then begin
      Result := false;
    end;
  end;
{$ENDIF}    
  end;
end;

procedure TIWTemplateProcessorHTML32.InitControl;
begin
  inherited;
  FMasterFormTag := True;
  FTemplates := TIWTemplateFiles32.Create;
end;

procedure TIWTemplateProcessorHTML32.Dispose(ADispose: Boolean);
begin
  FreeAndNil(FTemplates);
  inherited;
end;

function TIWTemplateProcessorHTML32.DoUnknownTag(const AName: string): string;
begin
  Result := '';
  if Assigned(OnUnknownTag) then begin
    OnUnknownTag(AName, Result);
  end;
end;

(*procedure TIWTemplateProcessorHTML32.Loaded;
var
  s: string;
begin
  inherited Loaded;
  if not IsDesignMode then begin
    if Length(Templates.Default) = 0 then begin
      s := Copy(Container.ContainerName, 2, MaxInt) + '.html';
      if Assigned(GServerController) and FileExists(GServerController.TemplateDir + s) then begin
        FTemplates.Default := s;
      end;
    end;
  end;
end;*)

procedure TIWTemplateProcessorHTML32.Process(AStream: TIWRenderStream;
  AContainerContext: TIWContainerContext; APageContext: TIWBasePageContext);
var
  LSrcStream: TStream;
  LPostStream: TStream;
  LMasterSrc: TStream;
  LMasterTemplate: string;
  LTemplatePathname : string;
  LAcceptLang : string;
  LLocalizedTemplatePathname : string;
begin
  // use localized template if any
  LTemplatePathname := TemplatePathname;
  LAcceptLang := APageContext.WebApplication.Request.GetFieldByName('Accept-Language');
  LAcceptLang := Fetch(LAcceptLang,',');
  LAcceptLang := Fetch(LAcceptLang,'-');
  LLocalizedTemplatePathname := Fetch(LTemplatePathname,'.') + '.' + LAcceptLang + '.' + LTemplatePathname;
  if FileExists(LLocalizedTemplatePathname) then begin
    LTemplatePathname := LLocalizedTemplatePathname;
  end else begin
    LTemplatePathname := TemplatePathname;
  end;

  if FileExists(LTemplatePathname) then begin
    LSrcStream := TFileStream.Create(LTemplatePathname, fmOpenRead + fmShareDenyWrite);
    try
      if Assigned(FOnBeforeProcess) then begin
        OnBeforeProcess(LSrcStream);
      end;
      if HTML32FormInterface(Container.InterfaceInstance)<>nil then begin
	      LMasterTemplate := GGetWebApplicationThreadVar.ActiveMasterTemplate;
	      if LMasterTemplate <>'' then begin
	        LMasterTemplate := GServerController.TemplateDir + LMasterTemplate;
	        if FileExists(LMasterTemplate) then begin
	          LMasterSrc := TFileStream.Create(LMasterTemplate, fmOpenRead + fmShareDenyWrite);
	          try
	            MergeTemplates(LSrcStream,LMasterSrc);
	          finally
	            FreeAndNil(LMasterSrc);
	          end;
	        end;
	      end;
      end;
      ProcessStream(AStream, LSrcStream, AContainerContext, APageContext);
    finally
      FreeAndNil(LSrcStream);
    end;
  end else begin
    LSrcStream := nil;
    if Assigned(FOnBeforeProcess) then begin
      OnBeforeProcess(LSrcStream);
    end;
    if Assigned(LSrcStream) then begin
      try
      	if HTML32FormInterface(Container.InterfaceInstance)<>nil then begin
	        LMasterTemplate := GGetWebApplicationThreadVar.ActiveMasterTemplate;
	        if LMasterTemplate<>'' then begin
	          LMasterTemplate := GServerController.TemplateDir + LMasterTemplate;
	          if FileExists(LMasterTemplate) then begin
	            LMasterSrc := TFileStream.Create(LMasterTemplate, fmOpenRead + fmShareDenyWrite);
	            try
	              MergeTemplates(LSrcStream,LMasterSrc);
	            finally
	              FreeAndNil(LMasterSrc);
	            end;
	          end;
	        end;
	      end;
        ProcessStream(AStream, LSrcStream, AContainerContext, APageContext);
      finally
        FreeAndNil(LSrcStream);
      end;
    end;
  end;
  if Assigned(FOnAfterProcess) then begin
    LPostStream := TStream(AStream);
    OnAfterProcess(LPostStream);
    if LPostStream<>AStream then try
      AStream.Size := 0;
      AStream.CopyFrom(LPostStream,0);
    finally
      LPostStream.Free;
    end;
  end;
end;

procedure TIWTemplateProcessorHTML32.ProcessStream(AStream: TIWRenderStream;  ATemplateStream: TStream;
 AContainerContext: TIWContainerContext; APageContext: TIWBasePageContext);
var
  i: Integer;
  LHeaderHasBeenWritten: Boolean;
  LParser: TCopyParser;
  LTagName: string;
  LTagParams: string;
  LName: string;
  LValue: String;
  LTerminated: Boolean;
  LWebApp: TIWApplication;
  LContext: TIWPageContext32;
  AFormProcessing: Boolean;
  LTemplate : string;
  LFormTag : string;

  function ProcessTag(AParser: TCopyParser; const AEndTagChar1, AEndTagChar2: Char): string;
  var
    LCtrlName: string;
    LHTML: TIWHTMLTag;
    LControl: IIWBaseHTMLComponent;
    LTmp: TIWRenderStream;
  begin
    result := '';
    with AParser do begin
      SkipToken(True);
      LCtrlName := TokenString;
      SkipToken(True);
      while Token = '.' do begin
        SkipToken(True);
        LCtrlName := LCtrlName + '.' + TokenString;
        SkipToken(True);
      end;

      if Length(LCtrlName) > 0 then begin
        if AContainerContext.IsValidComponent(LCtrlName) then begin
          LControl := BaseHTMLComponentInterface(AContainerContext.Components[LCtrlName]);
          LHTML := TIWBaseHTMLComponentContext(AContainerContext.ComponentContext[LCtrlName]).HTMLTag;
          Result := '';
          if Assigned(LHTML) then try
            LTmp:=TIWRenderStream.Create;
            try
              LControl.MakeHTMLTag(LHTML, LTmp);
              Result := LTmp.Extract;
            finally
              LTmp.Free;
            end;
          except on EAbort do end;
        end else begin
          Result := DoUnknownTag(LCtrlName);
        end;
      end;
      // SkipToken(True);
      if TagType <> ttBorland then begin
        CheckToken(AEndTagChar1);
        SkipToken(True);
      end;
      CheckToken(AEndTagChar2);
      SkipToken(True);
    end;
  end;

  procedure SkipAndOutput(AParser: TCopyParser);
  begin
    with AParser do begin
      CopyTokenToOutput;
      SkipToken(True);
    end;
  end;

  procedure SkipOverNextHTMLTag(AParser: TCopyParser);
  begin
    with AParser do begin
      SkipToToken('<');
      SkipToken(True);
      CheckToken('/');
      SkipToToken('>');
      SkipToken(True);
    end;
  end;

  procedure WriteHead;
  begin
    LHeaderHasBeenWritten := True;
    AStream.WriteString('<HEAD>' + DebugEOL
      + iif( GServerController.CharSet , '<META HTTP-EQUIV="Content-Type" CONTENT="text/html; CHARSET='+GServerController.CharSet+'">' + DebugEOL)
      + HeadContent);
  end;

begin
  LContext := TIWPageContext32(APageContext);
  ATemplateStream.Position := 0;

  if not MasterFormTag then begin
    LFormTag :=  '<form action="' +  APageContext.WebApplication.FormAction + '" method="post">';
    LTemplate := ReadStringFromStream(ATemplateStream,ATemplateStream.Size);
    LTemplate := IWTextReplace(LTemplate, '<form>', LFormTag);
    ATemplateStream := TStringStream.Create(LTemplate);
    ATemplateStream.Position := 0;
  end;

  LParser := TCopyParser.Create(ATemplateStream, AStream); try
  LHeaderHasBeenWritten := false;
  AFormProcessing := SupportsInterface(Container.InterfaceInstance, IIWHTML32Form);

    LTerminated := False;
    if Assigned (GGetWebApplicationThreadVar) then begin
      LWebApp := GGetWebApplicationThreadVar;
      LTerminated := Assigned(LWebApp) and LWebApp.Terminated;
    end;

    with LParser do begin
      while Token <> toEOF do begin
        case Token of
          '<': begin
            // SkipToken first in case of short circuit
            if (SkipToken(True) = '#') and (TagType = ttBorland) then begin
              StreamWrite(AStream, ProcessTag(LParser, '#', '>'));
            end else begin
              // <!DOCTYPE - etc. this is why TokenString + SkipTo
              LTagName := TokenString;
              // Must be separate from above, SkipToToken modfies result value of TokenString
              LTagName := LTagName + SkipToToken('>');
              //
              i := Pos(' ', LTagName);
              if i > 0 then begin
                LTagParams := Copy(LTagName, i + 1, MaxInt);
                SetLength(LTagName, i - 1);
                LTagParams := StringReplace(LTagParams, '../files/', LContext.URLBase + '/files/'
                 , [rfReplaceAll, rfIgnoreCase]);
              end else begin
                LTagParams := '';
              end;
              if AnsiSameText(LTagName, 'BODY') then begin

                // process BODY tag
                //------------------------------------------------------------
                if AFormProcessing then begin

                  // it's form template
                  //----------------------------------------------------------
                  while Length(LTagParams) > 0 do begin
                    LName := Trim(Fetch(LTagParams));
                    LValue := LName;
                    LName := Trim(Fetch(LValue, '='));
                    if AnsiPos('"', LValue) > 0 then begin
                      Fetch(LValue, '"');
                      if AnsiPos('"', LValue) = 0 then begin
                        LTagParams := LValue + LTagParams;
                        LValue := Fetch(LTagParams, '"');
                      end else begin
                        LValue := Fetch(LValue, '"');
                      end;
                    end else begin
                      if AnsiPos('''', LValue) > 0 then begin
                        Fetch(LValue, '''');
                        if AnsiPos('''', LValue) = 0 then begin
                          LTagParams := LValue + LTagParams;
                          LValue := Fetch(LTagParams, '''');
                        end else begin
                          LValue := Fetch(LValue, '''');
                        end;
                      end;
                    end;
                    if LName <> '' then begin
                      if AnsiSameText(LName, 'BGCOLOR') then begin
                        if LContext.BodyTag.Params.Values['BGCOLOR'] = '' then begin
                          LContext.BodyTag.AddStringParam('BGCOLOR', LValue);
                        end;
                      end else begin
                        if LValue <> '' then begin
                          LContext.BodyTag.AddStringParam(LName, LValue);
                        end else begin
                          LContext.BodyTag.Add(LName);
                        end;
                      end;
                    end;
                  end;
                  if not LHeaderHasBeenWritten then begin
                    WriteHead;
                  end;
                  LContext.BodyTag.ClosingTag := cbFalse;
                  LContext.BodyTag.Render(AStream);
                  SkipToken(True);
                  if MasterFormTag and not LTerminated then begin
                    LContext.FormTag.ClosingTag := cbFalse;
                    LContext.FormTag.Render(AStream);
                  end;

                end else begin
                  // it's NOT a form template
                  //----------------------------------------------------------
                  SkipToken(False);
                end;
                LHeaderHasBeenWritten := true;

              end else if AnsiSameText(LTagName, '/BODY') then begin
                if AFormProcessing then begin
                  if not LTerminated then begin
                    if not MasterFormTag then begin
                      LContext.FormTag.ClosingTag := cbFalse;
                      LContext.FormTag.Render(AStream);
                      // SkipToken(True);// Added. Fixes CR bug. 26/04
                    end;
                    StreamWrite(AStream, '</FORM>' + DebugEOL);
                  end;
                  StreamWrite(AStream, '</BODY>');
                  SkipToken(True); // Added. Fixes CR bug. 26/04
                end else begin
                  LHeaderHasBeenWritten := false; // trick to skip the </html>
                  SkipToken(False);
                end;
              end else if AnsiSameText(LTagName, 'HEAD') then begin
                if AFormProcessing then begin
                  if not LHeaderHasBeenWritten then begin
                    WriteHead;
                  end;
                  SkipToken(True);                  
                end else begin
                  SkipToken(False);
                end;
              end else if AnsiSameText(LTagName, 'TITLE') then begin
                if AFormProcessing then begin
                  if Length(LContext.Title) > 0 then begin
                    SkipOverNextHTMLTag(LParser);
                    StreamWriteLn(AStream, '<TITLE>' + LContext.Title + '</TITLE>');
                  end else begin
                    StreamWrite(AStream, '<TITLE>');
                    SkipToken(True); // Added. Fixes CR bug. 26/04
                  end;
                end else begin
                  SkipToken(False);
                end;
              end
              else begin
                // it isn't neither BODY, /BODY, HEAD, TITLE
                //------------------------------------------------------------
                if LHeaderHasBeenWritten or AFormProcessing then begin
                  StreamWrite(AStream, '<' + Trim(LTagName + ' ' + LTagParams) + '>');
                  SkipToken(True);// Added. Fixes CR bug. 26/04
                end else begin
                  SkipToken(False);
                end;
              end;
            end;
          end;
          '{': begin
            LValue := SkipTo(2);
            if (LValue = '{%') and (TagType = ttIntraWeb) then begin
              // SkipToken first in case of short circuit
              // if (SkipToken(True) = '%') and (TagType = ttIntraWeb) then begin
              //SkipToken(True);
              StreamWrite(AStream, ProcessTag(LParser, '%', '}'));
            end else begin
              SkipAndOutput(LParser);
            end;
          end else begin
            if AFormProcessing or LHeaderHasBeenWritten then begin
              SkipAndOutput(LParser);
            end else begin
              SkipToken(False);
            end;
          end;
        end;
      end;
    end;
  finally
    FreeAndNil(LParser);
  end;

  if not MasterFormTag then begin
    ATemplateStream.Free;
  end;
end;

procedure TIWTemplateProcessorHTML32.SetTemplates(const AValue: TIWTemplateFiles32);
begin
  FTemplates.Assign(AValue);
end;

function TIWTemplateProcessorHTML32.TemplatePathname: string;
Var
  S: String;
begin
  if Templates.Default = '' then begin
    // This is for subtemplates of regions. Right now containername returns:
    // formName.regionName. We rename it to formNameRegionName and that way
    // if no name is specified for the templates for regions, it uses this as
    // the default one
    if Assigned(Container) then begin
      // Remove the T from subclass name (AFTER the .)
      if (Length(s) > 0) and (Pos('.T', UpperCase(s)) > 0) then begin
        s := StringReplace(UpperCase(Container.ContainerClassNAme), '.T', '', []);
      end;
      s := StringReplace(Container.ContainerClassName, '.', '', []);
      // Remove T from it
      if (Length(s) > 0) and (AnsiSameText(s[1], 'T')) then begin
        Delete(s,1,1);
      end;
      s := s + '.html';
    end else begin
      s := '';
    end;
    if Assigned(GServerController) and FileExists(GServerController.TemplateDir + s) then begin
      FTemplates.Default := s;
    end;
  end;
  Result := GServerController.TemplateDir + FTemplates.Default;
end;

{ TIWTemplateFiles32 }

procedure TIWTemplateFiles32.AssignTo(ADest: TPersistent);
begin
  if ADest is TIWTemplateFiles32 then begin
    with TIWTemplateFiles32(ADest) do begin
      Default := Self.Default;
    end;
  end else begin
    inherited;
  end;
end;

constructor TIWTemplateFiles32.Create(ADefault: String);
begin
  inherited Create;

  FDefault := ADefault;
end;

end.
